/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (AbstractMemory.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: AbstractMemory.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx;

/**
 * @author martin
 */
public abstract class AbstractMemory 
implements Memory 
{

    /* (non-Javadoc)
     * @see org.fremo.ihx.Memory#nextUsedAddress(int)
     */
    public int nextUsedAddress(int address) 
    throws InvalidAddressException 
    {
        AbstractMemory.checkAddress(address);
        int a = address;
        while( a<=Memory.ADDRESS_HIGH && !this.isDefined(a) ) {
            a++;
        }
        //now: this.isDefined(a) || a>Memory.ADDRESS_HIGH
        if( a>Memory.ADDRESS_HIGH ) {
            return -1;
        }
        return a;
    }

    protected static void checkAddress(int address) 
    throws InvalidAddressException
    {
        if( address < ADDRESS_LOW || address > ADDRESS_HIGH ) {
            throw new InvalidAddressException("Address "
                                              +address
                                              +"is invalid");
        }
    }

    /* (non-Javadoc)
     * @see org.fremo.ihx.Memory#set(int, int)
     */
    public void set(int address, int value) 
    throws InvalidAddressException 
    {
        if( value < -128 || value > 256 ) {
            throw new IllegalArgumentException("invalid value="+value);
        }
        this.set(address, (byte) value);
    }
}
